//
//  YHCertificateAppointOptionCell.swift
//  galaxy
//
//  Created by edy on 2024/8/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHCertificateAppointOptionCell: UITableViewCell {

    static let cellReuseIdentifier = "YHCertificateAppointOptionCell"

    // 选择是否赴港
    var isSelectGoHK: Bool? {
        didSet {
            var selectIndex = -1 // 是否都未选择
            if let isGoHK = isSelectGoHK {
                selectIndex = isGoHK ? 0 : 1
            }
            optionsView.selectIndex = selectIndex
        }
    }
    
    var selectBlock: ((Int) -> Void)?
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("*", .font(UIFont.PFSC_M(ofSize: 17)), .foreground(UIColor.failColor))
        let b: ASAttributedString = .init("赴港办证", .font(UIFont.PFSC_M(ofSize: 17)), .foreground(UIColor.mainTextColor))
        label.attributed.text = a+b
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("备注：如您已获得香港居民身份证，此时无需再赴港办理身份证，", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.init(hex: 0x94A3B8)))
        let b: ASAttributedString = .init("则选择“否”", .font(UIFont.PFSC_R(ofSize: 13)), .foreground(UIColor.brandMainColor))
        label.attributed.text = a+b
        return label
    }()
    
    lazy var optionsView: YHInfoItemOptionView = {
        let view = YHInfoItemOptionView(frame: .zero)
        view.title = "是否赴港办证"
        view.options = ["是", "否"]
        view.selectIndex = -1
        view.selectBlock = {
            [weak self] index in
            guard let self = self else { return }
            self.selectBlock?(index)
        }
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(optionsView)

        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        optionsView.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(10)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.bottom.equalTo(-8)
        }
    }
}
